<?php 

// user private page container - contents when unlogged
function pc_so_pvtpag_content() {
	return array(
		'original_content'		=> __("Original content", PC_ML),
		'original_plus_form'	=> __("Original content + login form", PC_ML),
		'form_plus_original'	=> __("Login form + original content", PC_ML),	
		'only_form'				=> __("Only login form", PC_ML),		
	);	
}



// WP user sync - emulable roles
function pc_wps_emulable_roles() {
	global $pc_wp_user;	
	$roles = array();
	
	foreach(get_editable_roles() as $role_id => $data) { 
		if(!in_array($role_id, $pc_wp_user->forbidden_roles)) {
			$roles[ $role_id ] = $data['name'];
		}
	}
				  
	return $roles;
}



// WP capabilities
function pc_wp_roles($role = false) {
	$roles = array(
		'read' 				=> __('Subscriber', PC_ML),
		'edit_posts'		=> __('Contributor', PC_ML),
		'upload_files'		=> __('Author', PC_ML),
		'edit_pages'		=> __('Editor', PC_ML),
		'manage_options' 	=> __('Administrator', PC_ML)
	);
	
	if($role) {return $roles[$role];}
	else {return $roles;}
}



// password strength options
function pc_psw_strength_opts() {
	return array(
		'chars_digits'	=> __('use characters and digits', PC_ML),
		'use_uppercase'	=> __('use uppercase characters', PC_ML),
		'use_symbols'	=> __('use symbols', PC_ML)
	);	
}